* central_limit_theorem.sas;
options pageno=1 linesize=80;
goptions reset=all;
title 'Demonstration of central limit theorem in action';
data cntrlmt;
	* Loop to generate 100000 random observations;
	do i = 1 to 100000;
		* A single Poisson observation with lambda = 1;
		y1 = ranpoi(0,1);
		* Mean of 5 Poisson observations;
		y5 = 0;
		do j = 1 to 5;
			y5 = y5 + ranpoi(0,1);
		end;
		y5 = y5/5;
		* Mean of 10 Poisson observations;
		y10 = 0;
		do j = 1 to 10;
			y10 = y10 + ranpoi(0,1);
		end;
		y10 = y10/10;
		* Mean of 50 Poisson observations;
		y50 = 0;
		do j = 1 to 50;
			y50 = y50 + ranpoi(0,1);
		end;
		y50 = y50/50;
		output;
	end;
	drop i j;
run;
* Print simulated data (first 25 observations);
proc print data=cntrlmt(obs=25);
run;
* Descriptive statistics, histograms, and normal quantile plots;
proc univariate data=cntrlmt;
	var y1 y5 y10 y50;
	histogram y1 y5 y10 y50 / vscale=count normal(w=3) wbarline=3 waxis=3 height=4;
	qqplot y1 y5 y10 y50 / normal waxis=3 height=4;
	symbol1 h=3;
run;
quit;
